using System;
using System.Collections.Generic;

class Program
{
    static void Main()
    {
        int n = int.Parse(Console.ReadLine());
        long[] x = new long[n];
        long[] y = new long[n];

        for (int i = 0; i < n; i++)
        {
            string[] tokens = Console.ReadLine().Split();
            x[i] = long.Parse(tokens[0]);
            y[i] = long.Parse(tokens[1]);
        }

        Dictionary<long, long> sumMap = new Dictionary<long, long>();
        Dictionary<long, long> diffMap = new Dictionary<long, long>();

        for (int i = 0; i < n; i++)
        {
            long sum = x[i] + y[i];
            long diff = x[i] - y[i];

            if (!sumMap.ContainsKey(sum))
            {
                sumMap[sum] = 0;
            }
            sumMap[sum]++;

            if (!diffMap.ContainsKey(diff))
            {
                diffMap[diff] = 0;
            }
            diffMap[diff]++;
        }

        long greetings = 0;

        foreach (KeyValuePair<long, long> kv in sumMap)
        {
            long c = kv.Value;
            greetings += c * (c - 1) / 2;
        }

        foreach (KeyValuePair<long, long> kv in diffMap)
        {
            long c = kv.Value;
            greetings += c * (c - 1) / 2;
        }

        Console.WriteLine(greetings);
    }
}